/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.automobility.util;

import io.github.foundationgames.automobility.automobile.AutomobileData;
import io.github.foundationgames.automobility.automobile.AutomobileEngine;
import io.github.foundationgames.automobility.automobile.AutomobileFrame;
import io.github.foundationgames.automobility.automobile.AutomobileWheel;
import io.github.foundationgames.automobility.item.AutomobilityItems;
import io.netty.buffer.ByteBuf;
import java.text.DecimalFormat;
import java.util.Optional;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public final class AUtils
extends Enum<AUtils> {
    public static final DecimalFormat DEC_TWO_PLACES;
    public static final Direction[] HORIZONTAL_DIRS;
    public static final StreamCodec<ByteBuf, Vec3> STREAM_CODEC_VEC3;
    private static final RandomSource RANDOM;
    private static final /* synthetic */ AUtils[] $VALUES;

    public static AUtils[] values() {
        return (AUtils[])$VALUES.clone();
    }

    public static AUtils valueOf(String name) {
        return Enum.valueOf(AUtils.class, name);
    }

    public static float zero(float in, float by) {
        return AUtils.shift(in, by, 0.0f);
    }

    public static int zero(int in, int by) {
        return AUtils.shift(in, by, 0);
    }

    public static float shift(float in, float by, float to) {
        if (Math.abs(in - to) < by) {
            return to;
        }
        if (in > to) {
            by *= -1.0f;
        }
        return in += by;
    }

    public static int shift(int in, int by, int to) {
        if (Math.abs(in - to) < by) {
            return to;
        }
        if (in > to) {
            by *= -1;
        }
        return in += by;
    }

    public static boolean haveSameSign(float a, float b) {
        if (a == 0.0f || b == 0.0f) {
            return a == b;
        }
        return a / Math.abs(a) == b / Math.abs(b);
    }

    public static float furthestFromZero(float a, float b) {
        return Math.abs(a) > Math.abs(b) ? a : (Math.abs(b) > Math.abs(a) ? b : a);
    }

    public static CompoundTag v3dToNbt(Vec3 vec) {
        CompoundTag r = new CompoundTag();
        r.putDouble("x", vec.x());
        r.putDouble("y", vec.y());
        r.putDouble("z", vec.z());
        return r;
    }

    public static Vec3 v3dFromNbt(CompoundTag nbt) {
        return new Vec3(nbt.getDouble("x"), nbt.getDouble("y"), nbt.getDouble("z"));
    }

    public static Vector3f colorFromInt(int color) {
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        return new Vector3f((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f);
    }

    public static int colorToInt(float a, float r, float g, float b) {
        int ia = (int)(a * 255.0f);
        int ir = (int)(r * 255.0f);
        int ig = (int)(g * 255.0f);
        int ib = (int)(b * 255.0f);
        return ia << 24 | ir << 16 | ig << 8 | ib;
    }

    public static boolean canMerge(ItemStack a, ItemStack b) {
        return ItemStack.isSameItem((ItemStack)a, (ItemStack)b) && a.getCount() + b.getCount() <= a.getMaxStackSize();
    }

    public static byte[] arrayOf(ByteBuf buffer) {
        int sz = buffer.readableBytes();
        byte[] r = new byte[sz];
        buffer.readBytes(r);
        return r;
    }

    public static boolean transferInto(ItemStack stack, Container inv) {
        for (int slot = 0; slot < inv.getContainerSize(); ++slot) {
            if (!inv.canPlaceItem(slot, stack)) continue;
            ItemStack slotStack = inv.getItem(slot);
            if (slotStack.isEmpty()) {
                inv.setItem(slot, stack);
                return true;
            }
            if (!AUtils.canMerge(slotStack, stack)) continue;
            int amount = Math.min(stack.getCount(), stack.getMaxStackSize() - slotStack.getCount());
            stack.shrink(amount);
            slotStack.grow(amount);
            return stack.isEmpty();
        }
        return false;
    }

    public static ItemStack createGroupIcon() {
        return new ItemStack((ItemLike)AutomobilityItems.CROWBAR.require());
    }

    public static ItemStack createPrefabsIcon() {
        return new AutomobileData(Optional.empty(), AutomobileFrame.STANDARD_LIGHT_BLUE, AutomobileWheel.STANDARD, AutomobileEngine.IRON).asStack();
    }

    private static /* synthetic */ AUtils[] $values() {
        return new AUtils[0];
    }

    static {
        $VALUES = AUtils.$values();
        DEC_TWO_PLACES = new DecimalFormat("###0.00");
        HORIZONTAL_DIRS = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST};
        STREAM_CODEC_VEC3 = StreamCodec.of((buf, v) -> {
            buf.writeDouble(v.x());
            buf.writeDouble(v.y());
            buf.writeDouble(v.z());
        }, buf -> new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble()));
        RANDOM = RandomSource.create();
    }
}

